#ifdef WIN32

#include "Dependence.h"
#include "csf/logger/CSFLogger.hpp"
#include "JCFCoreUtils/StringUtils.h"
#include "csfunified/services/interface/SystemService.h"
#include "csfunified/services/interface/ConfigService.h"
#include "csfunified/services/interface/ConfigValue.h"
#include "csfunified/featuresets/MeetingFeatureSet.h"
#include "csfunified/services/interface/DesktopSharingController.h"

#define  WapiOrgId  L"WapiOrgId"
#define  WapiUserId  L"WapiUserId"
#define  WapiGroupId L"WapiGroupId"


namespace CSFUnified
{
	static CSFLogger* DependenceLogger = CSFLogger_getLogger("MeetingService-JabberMeetingDependence");

	CDependence* CDependence::m_pDependence = NULL;

	CDependence::CDependence(void)
	{
		m_pIMMgr = NULL;
		m_pDSMgr = NULL;
		m_pMMMgr = NULL;
		m_bFeatureStartFlag = false;
		m_pIJabberSDKWrap = NULL;

		m_commonHelper = &JabberWerxCommonHelper::getInstance();
	}	

	CDependence::~CDependence(void)
	{
	}

	CDependence* CDependence::getInstance()
	{
		if(NULL == m_pDependence)
		{
			m_pDependence = new CDependence();
			//m_pDependence->GetJabberWerxCommonHelper()->InitHelper(m_pDependence->GetUnifiedFactory());
			////m_pDependence->m_commonHelper.InitHelper(m_pDependence->m_UnifiedFactory);
		}

		return m_pDependence;
	}

	void CDependence::releaseInstance()
	{
		if (NULL != m_pDependence)
		{
			delete m_pDependence;
			m_pDependence = NULL;
		}
	}

	void CDependence::start()
	{
		m_bFeatureStartFlag = true;

		if (NULL == m_pIJabberSDKWrap)
		{
			CDependence::getInstance();
			m_pIJabberSDKWrap = JabberSDKWrapImpl::getInstance();
			if (NULL == m_pIJabberSDKWrap)
			{
				CSFLogErrorS(DependenceLogger, "CDependence::start dependence fail");
			}
			setupDependence(m_pIJabberSDKWrap);

			if (NULL != m_pIJabberSDKWrap->getCommonEventCallback())
			{
				m_pIJabberSDKWrap->getCommonEventCallback()->OnSignOn();
			}

			m_imMgr.Init();

			setSpecialInWebExMeetingFlag();

			m_pIMMgr = m_pIJabberSDKWrap->getIInstantMeetingMgr();
			m_pDSMgr = m_pIJabberSDKWrap->getIDSMgr();
			m_pMMMgr = m_pIJabberSDKWrap->getJMMeetingMgr();
		}

	}

	void CDependence::stop()
	{
		m_bFeatureStartFlag = false;

		if (NULL != m_pIJabberSDKWrap && NULL != m_pIJabberSDKWrap->getCommonEventCallback())
		{
			if (m_UnifiedFactory != NULL)
			{
				if (m_UnifiedFactory->getFeatureSet<MeetingFeatureSet>()!=NULL)
				{
					m_UnifiedFactory->getFeatureSet<MeetingFeatureSet>()->getDesktopSharingController()->stopSharing();
				}
				
			}
			m_pIJabberSDKWrap->getCommonEventCallback()->OnSignOff();
		}

		m_pIMMgr = NULL;
		m_pDSMgr = NULL;
		m_pMMMgr = NULL;
		m_pIJabberSDKWrap = NULL;
	}

	//IMeetingAccountInfoCallback * CDependence::GetMeetingAccountInfoCallback()
	//{
	//	if (NULL != m_pIJabberSDKWrap)
	//	{
	//		return m_pIJabberSDKWrap->getMeetingAccountCallback();
	//	}

	//	return  NULL;
	//}

	IJMIMCallback * CDependence::GetIMCallback()
	{
		if (NULL != m_pIJabberSDKWrap)
		{
			return m_pIJabberSDKWrap->getIMCallback();
		}

		return  NULL;
	}

	IJabberSDKWrap * CDependence::GetJabberSDKWrap()
	{
		return m_pIJabberSDKWrap;
	}

	JabberWerxCommonHelper *CDependence::GetJabberWerxCommonHelper()
	{
		return m_commonHelper;
	}

	IMMgrHelper& CDependence::GetIMMgr()
	{
		return m_imMgr;
	}


	//void CDependence::ReportUsage(std::wstring strUsageString)
	//{
	//	if (NULL == m_UnifiedFactory)
	//	{
	//		return;
	//	}

	//	std::wstring eventName = strUsageString;
 //       std::wstring extraData = L"<eventWorkspaceID></eventWorkspaceID>";
 //       std::wstring orgId = L"";
 //       std::wstring userId = L"";
 //       std::wstring groupId = L"";
 //
	//	SMART_PTR_NS::shared_ptr<ConfigService> ptrConfigSvc = m_UnifiedFactory->getService<ConfigService>();
	//	if (NULL != ptrConfigSvc)
	//	{
	//		orgId = ptrConfigSvc->getConfig(WapiOrgId)->getValue();
	//		userId = ptrConfigSvc->getConfig(WapiUserId)->getValue();
	//		groupId = ptrConfigSvc->getConfig(WapiGroupId)->getValue();
	//	}

	//	wostringstream extendedData;
	//	extendedData << L"<orgID>" << orgId << L"</orgID><userID>" << userId << L"</userID><groupID>" << groupId << L"</groupID>";

	//	SMART_PTR_NS::shared_ptr<SystemService> ptrSystemSvc = m_UnifiedFactory->getService<SystemService>();
	//	if (NULL == ptrSystemSvc)
	//	{
	//		CSFLogInfoS(DependenceLogger, "CDependence::ReportUsage(), Get SystemService faile.");
	//		return;
	//	}
 //       ptrSystemSvc->SubmitUsageData(L"SYS_CUSTOM_EVENTS", eventName, extraData, extendedData.str());

	//	std::wstring extData = extendedData.str();
	//	CSFLogInfoS(DependenceLogger, "CDependence::ReportUsage eventType:SYS_CUSTOM_EVENTS eventName: " << JCFCoreUtils::toString(eventName).c_str()
	//		<< " exTraData: " << JCFCoreUtils::toString(extraData).c_str()
	//		<< " extendedData: " << JCFCoreUtils::toString(extData).c_str());
	//}

	void CDependence::setupDependence(IJabberSDKWrap* pIJabberSDKWrap)
	{
		if (NULL == pIJabberSDKWrap)
		{
			return;
		}

		pIJabberSDKWrap->setIMMgrDelegate(&m_imMgr);
		pIJabberSDKWrap->setCommonDependenceDelegate(m_commonHelper);
	}

	void CDependence::SetUnifiedFactory( SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory )
	{
		m_UnifiedFactory = unifiedFactory;
	}

	SMART_PTR_NS::shared_ptr<UnifiedFactory> CDependence::GetUnifiedFactory()
	{
		return m_UnifiedFactory;
	}

	void CDependence::setSpecialInWebExMeetingFlag()
	{
		if (NULL == m_UnifiedFactory)
		{
			return;
		}

		bool isEnable = false;

		SMART_PTR_NS::shared_ptr<ConfigService> ptrConfigSvc = m_UnifiedFactory->getService<ConfigService>();
		if (NULL != ptrConfigSvc)
		{
			std::wstring value = ptrConfigSvc->getConfig(L"CalendarWebExMeetingPresence")->getValue();
			CSFLogInfoS(DependenceLogger, "CDependence::setSpecialInWebExMeetingFlag Special flag = " << JCFCoreUtils::toString(value).c_str());
			if (JCFCoreUtils::caseInsensitiveStringEquals(value, L"true"))
			{
				isEnable = true;
			}
		}
		m_commonHelper->SetEnableSpecialInWebExMeetingPresence(isEnable);
	}
}

#endif